#ifdef GL_ES
precision mediump float;
#endif
#define M_PI 3.14159265358979323846f	/* pi */

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

float _abs(float a)
{
	if(a<0)
		return -a;
	else
		return a;
}
//float progress = PREFIX(global_time);
//vec2 resolution = iResolution;
 


float quadraticInOut(float t) {
  float p = 2.0f * t * t;
  return t < 0.5f ? p : -p + (4.0f * t) - 1.0f;
}

float linearInterp(vec2 range, vec2 domain, float x) {
  return mix(range.x, range.y, smoothstep(domain.x, domain.y, clamp(x, domain.x, domain.y)));
}

float getGradient(float r, float dist) {
	float smoothness = 0.02f;
  float grad = smoothstep(-smoothness, 0.0f, r - dist * (1.0f + smoothness)); //, 0.0, 1.0);
  if (r - dist < 0.005f && r - dist > -0.005f) {
    return -1.0f;
  } else if (r - dist < 0.01f && r - dist > -0.005f) {
   return -2.0f;
  }
  return grad;
}


float getWave(vec2 p,float progress){
  
  // I'd really like to figure out how to make the ends meet on my circle.
  // The left side is where the ends don't meet.
   vec2 center = (vec2)(0.5f, 0.5f);
  vec2 _p = p - center; // offset from center
  float rads = atan2(_p.y, _p.x);
  float degs = degrees(rads) + 180.0f;
  vec2 range = (vec2)(0.0f, M_PI * 30.0f);
  vec2 domain = (vec2)(0.0f, 360.0f);
  
  float ratio = (M_PI * 30.0f) / 360.0f;
  //degs = linearInterp(range, domain, degs);
  degs = degs * ratio;
  float x = progress;
  float magnitude = mix(0.02f, 0.09f, smoothstep(0.0f, 1.0f, x));
  float offset = mix(40.0f, 30.0f, smoothstep(0.0f, 1.0f, x));
  float ease_degs = quadraticInOut(sin(degs));
  
  float deg_wave_pos = (ease_degs * magnitude) * sin(x * offset);
  return x + deg_wave_pos;
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	vec2 center = (vec2)(0.5f, 0.5f);
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	
	vec2 p = tc;
	float4 gl_FragColor;
	if (progress == 0.0f) {
		gl_FragColor = INPUT(input1, param, p);
	} else if (progress == 1.0f) {
		gl_FragColor = INPUT(input2, param,p);
	} else {
		float dist = distance(center, p);
		float m = getGradient(getWave(p,progress), dist);
		if (m == -2.0f) {
		  //gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
		  //gl_FragColor = mix(INPUT1(p), INPUT2(p), -1.0);
		  gl_FragColor = mix(INPUT(input1, param,p), (vec4)(0.0f, 0.0f, 0.0f, 1.0f), 0.75f);
		} else {
		  gl_FragColor = mix(INPUT(input1, param,p), INPUT(input2, param,p), m);    
		}
	}
  write_imagef(dstImg, (int2)(w, textH - h -1), gl_FragColor);
}
